import ftd2xx as ftd


class OSW():

   
    # Parameters
    baudrate = 230400
    DEVNO = -1
    
    def __init__(self):
        
        self.isConnected = False
        self.d=0
    
        # list all connected ftdi devices
        dlist=ftd.listDevices(2)
        if len(dlist) > 0:
            counter=0
            for dev in dlist[:]:
                print("    " + str(counter) + ": " + dev.decode('UTF-8'))
                counter = counter + 1
            print("    Select Instrument (-1 to Quit):")
            self.DEVNO = int(input())
        else:
             print("    No Instrument found")
        return
        
        
        
    def open( self):
    
        self.d = ftd.open(self.DEVNO)    # Open selected FTDI device
        self.d.setBaudRate(self.baudrate)
        self.d.setDataCharacteristics(8, 0, 0)
        self.isConnected = True
        print( "Connected." )
        return
        
    def close( self ):
        self.d.close()
        self.isConnected = False
        print( "Closed." )
        return
        
        
    def setbitmode(self, mask, mode):
        self.d.setBitMode(mask, mode)
        return
        
     
    def setswitch(self, state):
        
        """
        state:
        Bit 0: switch 1
        Bit 1: switch 2
        Bit 2: switch 3
        """
        
        self.setbitmode(0xF0 + 2*state, 0x20)
        return
        
    
        
        
