isOctave = exist('OCTAVE_VERSION', 'builtin') ~= 0;

if isOctave,
   addpath ..\OCT10
else
   addpath ..\MEX
end;
addpath ..\COM

%isConnected = PM1000.init; % connect to last selected instrument
%isConnected = PM1000.init(0); % user select driver and instrument
%isConnected = PM1000.init('192.168.1.171') % TCP for earlier PM1000s with 100MBit/s LAN interface
isConnected = PM1000.init('UDP192.168.1.70') % UDP for recent PM1000s with 1GBit/s LAN interface 

if ~isConnected,
   return;
end;


firmware_version = PM1000.getfirmware

serial_number = PM1000.getserialnumber

module_type = PM1000.getmoduletype

PM1000.setATE(12);
ATE = PM1000.getATE

Stokes = PM1000.getStokes(1)

Power_uW = PM1000.getPower

ME=10; PM1000.setME(ME); % Memory Exponent (ME). 2^10 = 1024 Samples
PM1000.write(512+74, 0) % set PowExp to 0
%% Triggering of PM1000
% Set all trigger conditions to "0" for manual recording:   
dyn_undersampling = 0;
trigonnextbnc  = 0;
syncextfalling = 0;
syncextrising  = 0;
cyclic         = 0;
PM1000.write(512+72, dyn_undersampling * 2^8 ... 
               + trigonnextbnc * 2^7 ...
               + syncextfalling * 2^6 ...
               + syncextrising * 2^5 ...
               + cyclic * 2^2 ...
               + ~trigonnextbnc);
PM1000.waitBusy;

dout = double(PM1000.getsdram(0, 2^ME));


% normalize Stokes parameters
dout1 = dout(1,:) % Power in uW
dout2 = (dout(2,:)-2^15)/2^15 % normalized Stokes1
dout3 = (dout(3,:)-2^15)/2^15 % normalized Stokes2
dout4 = (dout(4,:)-2^15)/2^15 % normalized Stokes3


PM1000.close


