isOctave = exist('OCTAVE_VERSION', 'builtin') ~= 0;

if isOctave,
   addpath ..\OCT10
else
   addpath ..\MEX
end;
addpath ..\COM

%isConnected = EPS1000.init; % connect to last selected USB instrument
%isConnected = EPS1000.init(0); % user select USB driver and instrument
isConnected = EPS1000.init('192.168.1.102'); % TCP connection

if ~isConnected,
   return;
end;

fw = EPS1000.getfirmware

sn = EPS1000.getserialnumber

wlenbands = EPS1000.getnrofwlenbands


freq = 190;
EPS1000.setoptfrequency(freq);

disp(sprintf("Frequency is now %f THz", EPS1000.getoptfrequency));

EPS1000.setdistrpeaked(10000); % set 10 krad/s Peaked distribution
%EPS1000.setdistrpeakedplus(12000000); % set 12 Mrad/s Peaked+ distribution
%EPS1000.setdistrrayleigh(1000000); % set 1 Mrad/s Rayleigh distribution
%EPS1000.setdistrdepol(16000000); % set 16 Mrad/s Depolarizer distribution


EPS1000.close


