classdef EPC1000

   properties
   
      model = "EPC1000"
      version = "0.9.0"
      
   end
   
   methods(Static)
   
      %%%%%%%%%%%%%%%%%%%%%%%
      % Basic communication %
      %%%%%%%%%%%%%%%%%%%%%%%
      
      function init(ARG)
         % EPC1000.init('192.168.1.100');    opens LAN device
         % EPC1000.init(1);                  opens last USB device
         % EPC1000.init(0);                  shows list of USB devices and lets user chose one
         % EPC1000.init;                     same as epc=EPC1000(1);
         
         if (nargin<1)
            ARG=1; % connect to last device
         end;
      
         global EPCHandle
         if length(ARG)>1&&sum(class(ARG)=='char')==4  % LAN DEVICE
            EPCHandle=NOVTCP(ARG);
         else % USB DEVICE
            EPCHandle=NOVUSB('LastDevEPC.mat', ARG);
         end;
         
      end;
      
      function close
         global EPCHandle
         EPCHandle.close; 
      end;
      
      function [res ok] = read(addr)
      
         global EPCHandle
         
         [res ok] = EPCHandle.read(addr);
         
         if ok==0, % su success in reading. Try to connect again
            EPC1000.init;
            [res ok] = EPCHandle.read(addr);
         end;
         
      end;
	  
	 
	  
      function [dout1 ok] = readburst(rdaddr, addrstart, addrstop, wraddr)
	  
         global EPCHandle
         [dout1 ok] = EPCHandle.readburst(rdaddr, addrstart, addrstop, wraddr);
         if ok==0, % su success in reading. Try to connect again
            EPC1000.init;
            [dout1 ok] = EPCHandle.readburst(rdaddr, addrstart, addrstop, wraddr);
         end;
		end;
		

      function ok = write(addr, data)
         global EPCHandle
         ok = EPCHandle.write(addr, data);
         if ok==0, % su success in writing. Try to connect again
            EPC1000.init;
            ok = EPCHandle.write(addr, data);
         end;
         
      end;
      
      %%%%%%%%%%%%%%%%%%%%%%%%%%%
      % General instrument data %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%
      
      function r = getfirmware % as string
         r = sprintf('%4X', EPC1000.read(16));
      end

      function r = getserialnumber
         r = EPC1000.read(23);
      end
      
      function r = getmoduletype % as string
         str=[];
         for ii=0:15,
            dummy = EPC1000.read(96+ii);
            str=[ str char(bitshift(dummy, -8)) ];
            str=[ str mod(dummy, 2^8) ];
         end;
         r = str;
      end
      
      %%%%%%%%%%%%%%%%%%%%%%%%%%%
      % General instrument data %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%
      
      function setcontrolenable(en)
         if en>0,
            EPC1000.write(1, 3);
         else
            EPC1000.write(1, 2);
         end;
      end

      function swapchannels
         EPC1000.write(2, 0);
      end

      function modulereset
         EPC1000.write(3, 1);
      end
      
      function setmaximize(max)
         EPC1000.write(4, max);
      end
      
      function setdetectmode(mode)
         r = uint16(EPC1000.read(8));
         r = bitand(r, bin2dec("1111111111111100")); % set last 2 bits to zero
         r = r + mode;
         EPC1000.write(8, double(r));
      end
      
      
      function setswitchmode(mode)
         r = uint16(EPC1000.read(8));
         r = bitand(r, bin2dec("0000000011111111")); % set upper 8 2 bits to zero
         r = r + mode*2^8;
         EPC1000.write(8, r);
      end
      
      function setate(ate) % = modtime
         EPC1000.write(32, ate);
      end
      
      function setmodstep(step) % = relmodstep
         EPC1000.write(33, step);
      end

      function setcontrolgain(gain)
         EPC1000.write(34, gain);
      end

      function setdelay(delay) % = upddelay
         EPC1000.write(35, delay);
      end
      
      function resetdefaults
         EPC1000.write(80, 4);
      end

      function loadsettings % from flash
         EPC1000.write(80, 2);
      end
      
      function savesettings % to flash
         EPC1000.write(80, 1);
      end
      
      function resetlanmodule
         EPC1000.write(80, 2^7);
      end
      
      function r = getapdvoltages
         r = zeros(2,1);
         r(1) = EPC1000.read(48);
         r(2) = EPC1000.read(49);
      end;

      function r = getphotocurrents
         r = zeros(2,1);
         r(1) = EPC1000.read(48);
         r(2) = EPC1000.read(49);
      end;
      
      function r = getintens % feedback signal
         r = EPC1000.read(64);
      end;
      
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % Apply User Confiugration %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%
      
      function configure
         EPC1000.setdetectmode(1); % detector mode 1
         EPC1000.setdelay(25);
         %EPC1000.setdelay(27);
         EPC1000.setmaximize(0);
         EPC1000.setcontrolgain(120);
         %EPC1000.write(253+1, 8192-1200);
         %EPC1000.write(253+2, 8192-700);
         EPC1000.setcontrolenable(1);
      end;
      
      

   end;

end